using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Net;
using System.IO;
using System.Windows.Forms;
using System.Diagnostics;

/*
 * Original code is from Neil Young (http://maps.alphadex.de/index.php?section=mylocation) modified by
 * Sebastian Herp ( see http://www.sebbi.de/archives/2008/04/25/google-maps-mylocation-in-c-sharp)
 * to work as a form based application. Some code is also based on this example on getting the geo location with
 * Google Android: http://davanum.wordpress.com/2007/12/01/android-much-better-geo-location-from-just-cellidlac/
 */


/* 
 * Sample code to obtain geo codes from a cell info
 * "GSM/UMTS" setting revealed by smuraro, thanks!
 */

/* (c) "Neil Young" (neil.young@freenet.de)
 * 
 * This script/program is provided "as is".
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * GNU General Public License, see <http://www.gnu.org/licenses/>.
 */


namespace Google_Maps_Locate_Me
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void writeShort(int n, MemoryStream ms)
        {
            byte[] r = new byte[] { 0x00, 0x00 };
            r[0] = (byte)((n >> 8) & 0xFF);
            r[1] = (byte)((n >> 0) & 0xFF);

            ms.Write(r, 0, 2);
        }

        private void writeLong(int n, MemoryStream ms)
        {
            byte[] r = new byte[] { 0x00, 0x00, 0x00, 0x00 };
            r[0] = (byte)((n >> 24) & 0xFF);
            r[1] = (byte)((n >> 16) & 0xFF);
            r[2] = (byte)((n >> 8) & 0xFF);
            r[3] = (byte)((n >> 0) & 0xFF);

            ms.Write(r, 0, 4);
        }

        private string hexString(byte[] b)
        {
            string temp = "";
            for (int i = 0; i < b.Length; i++)
            {
                temp += b[i].ToString("X2") + " ";
            }
            return temp;
        }

        private byte[] PostData(int MCC, int MNC, int LAC, int CID)
        {
            
            //strings ... byte[] byteArray = Encoding.UTF8.GetBytes(postData);
            byte[] r = new byte[55];


            MemoryStream ms = new MemoryStream(r);
            writeShort(0x0E, ms);                   // Fct code 0e
            writeLong(0, ms); writeLong(0, ms);     // 8 byte session
            writeShort(0, ms);                      // length of country code
            // contry code string
            writeShort(0, ms);                      // length of client descriptor
            // client descriptor string
            writeShort(0, ms);                      // length of version tag
            // version tag string

            ms.WriteByte(0x1B);                     // Fct code 1b
            writeLong(0, ms);                       // MNC?
            writeLong(0, ms);                       // MCC?
            writeLong(3, ms);                       // Radio Access Type (3=GSM, 5=UMTS)
            writeShort(0, ms);                      // length of provider name
            // provider name string
            writeLong(CID, ms);                     // CID
            writeLong(LAC, ms);                     // LAC
            writeLong(MNC, ms);                     // MNC
            writeLong(MCC, ms);                     // MCC
            writeLong(-1, ms);                      // always 0xffffffff = -1
            writeLong(0, ms);                       // rx level?
            
            ms.Dispose();
            return r;
        }

        private HttpWebResponse httpPost(byte[] postdata, out byte[] reply)
        {
            HttpWebResponse res = null;
            //MessageBox.Show(hexString(postdata) + "\nlen = " + postdata.Length);


            String url = "http://www.google.com/glm/mmap";
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(new Uri(url));
            req.Method = "POST";
            req.ContentLength = postdata.Length;
            req.ContentType = "application/binary";
            Stream outputStream = req.GetRequestStream();
            outputStream.Write(postdata, 0, postdata.Length);
            outputStream.Close();

            res = (HttpWebResponse)req.GetResponse();
            reply = new byte[res.ContentLength];
            int totalBytesRead = 0;
            while (totalBytesRead < reply.Length)
            {
                totalBytesRead += res.GetResponseStream().Read(reply, totalBytesRead, reply.Length - totalBytesRead);
            }

            return res;
        }

        private void buttonLocate_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] ps;
                int mcc = Convert.ToInt32(textBoxMCC.Text);
                int mnc = Convert.ToInt32(textBoxMNC.Text);
                int lac = Convert.ToInt32(textBoxLAC.Text);
                int cid = Convert.ToInt32(textBoxCID.Text);
                byte[] pd = PostData(mcc, mnc, lac, cid);
                //MessageBox.Show(hexString(pd) + "\nlen = " + pd.Length);


                HttpWebResponse res = httpPost(pd, out ps);
                //MessageBox.Show(hexString(ps) + "\nlen = " + ps.Length);
                
                if (res.StatusCode == HttpStatusCode.OK)
                {
                    short opcode1 = (short)(ps[0] << 8 | ps[1]);
                    byte opcode2 = ps[2];
                    System.Diagnostics.Debug.Assert(opcode1 == 0x0e);
                    System.Diagnostics.Debug.Assert(opcode2 == 0x1b);
                    int ret_code = (int)((ps[3] << 24) | (ps[4] << 16) | (ps[5] << 8) | (ps[6]));

                    if (ret_code == 0)
                    {
                        MyLocation ml = new MyLocation(ps, mcc, mnc, lac, cid);
                        listBox.Items.Add(ml);
                    }
                    else
                        MessageBox.Show("Error " + ret_code.ToString());
                }
                else
                    listBox.Items.Add("HTTP Status " + res.StatusCode.ToString() + " " + res.StatusDescription);
            }
            catch (Exception)
            {
                MessageBox.Show("HTTP Error?");
            }
           
        }


        private void listBox_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            MyLocation ml = (MyLocation)((ListBox)sender).SelectedItem;
            Process p = new Process();
            p.StartInfo.FileName = String.Format("http://maps.google.com/maps?f=q&q={0},{1}&z=14", ml.lat.ToString().Replace(',', '.'), ml.lon.ToString().Replace(',', '.'));
            p.Start();
        }
    }

    public class MyLocation
    {
        public double lat, lon;
        int mcc, mnc, lac, cid;

        public MyLocation(byte[] ps, int mcc, int mnc, int lac, int cid)
        {
            lat = ((double)((ps[7] << 24) | (ps[8] << 16) | (ps[9] << 8) | (ps[10]))) / 1000000;
            lon = ((double)((ps[11] << 24) | (ps[12] << 16) | (ps[13] << 8) | (ps[14]))) / 1000000;
            this.mcc = mcc;
            this.mnc = mnc;
            this.lac = lac;
            this.cid = cid;
        }

        public override string ToString()
        {
            return "Latitude: " + lat.ToString() + " Longitude: " + lon.ToString() + " from MCC: " + mcc.ToString() + ", MNC: " + mnc.ToString() + ", LAC: " + lac.ToString() + ", Cell ID: " + cid.ToString();
        }
    }
}